# -*- coding: utf-8 -*-
"""
Created on Mon Jul 12 17:28:04 2021

@author: Nicole
"""


#########  CAPACITE NUMERIQUE N°3

## Mettre en oeuvre la méthode d'Euler pour simuler la réponse d'un système
## linéaire du premier ordre à  une excitation de forme quelconque : du/dt + u/tau = e(t)/tau
## Pour que le circuit atteigne rapidement son regime permanent stationnaire, 
## il faut que la période du signal d'entrée soit grande devant la constante de temps


## Circuit RC soumis à une excitation quelconque

# Importation des bibliothèques utiles
import numpy as np
import matplotlib.pyplot as plt
     
#Caractéristiques du circuit d'ordre 1 
tau = 10                     # constante de temps en secondes
w0 = 1/ tau                  # pulsation caractéristique = pulsation de coupure en rad/s
f0 = w0/(2*np.pi)            # fréquence caractéristique = fréquence de coupure en Hz

# Condition initiale
u0 = 12                    # tension initiale aux bornes de C en V

# Données sur le signal d'entrée e(t) 
E = 6                       # amplitude de e(t) en V
Te = 5                       # période de e(t) en s
we = 2*np.pi/Te              # pulsation de e(t)
fe = we/(2*np.pi)            # fréquence de e(t)

# e(t) est un signal carré, décommenter les 2 lignes suivantes, commenter les lignes 43 et 44
# def g(t) :
#     return (np.sign(np.sin(we*t))+ 1)/2            # on modélise un signal carré d'amplitude 1
                                                     # de valeur moyenne non nulle

# e(t) est une fonction sinusoidale, raisonner alors en régime fréquentiel pour le régime permanent
def g(t) :
    return np.cos(we*t)

def f2(u, t) :                                     # u(t) est la tension aux bornes du condensateur
    return (E*g(t)-u)/(tau)                        # du/dt = f2(u, t)=(e(t)-u)/(tau). On cherche la liste u
                                                   #

def f3(u, t) :                                     # u(t) est la tension aux bornes du condensateur
    return (0-u)/(tau)                           # avec e(t) = E/2, prendre E pour e(t) sinusoïdale

#  Méthode d'Euler explicite
def euler(f,u0,a,b,n):                      # a valeur initiale de t, b valeur finale de t
    h=(b-a)/n                               # n intervalles, n+1 valeurs
    t=np.linspace(a,b,n+1)                  # crée le tableau des temps
    u=[0]*(n+1)                             # crée une liste remplie de n+1 zéros
    u[0]=u0                                 # condition initiale
    for i in range(0,n):                    # n+1 éléments dans la liste u car n intervalles
        u[i+1]=u[i]+h*f(u[i],t[i])          # fonction d'Euler sous forme de tableau
                                            # ou u=[u0] et u.append(u[i]+h*f(u[i],t[i])
    return u,t

# arguments Euler
n = 2000                                  # n intervalles, pb pour le carré si n est trop petit
a = 0
b = 6*tau

# affichage des fréquences
print("la fréquence d'entrée est " + str(fe)+ ' Hz')
print("la fréquence de coupure du filtre est {:.2} Hz".format(f0))      #nb de CS de f0

# appel de la fonction Euler
u2, t = euler(f2, u0, a, b, n)                # on donne les valeurs de a et b d'Euler
u3, t = euler(f3, u0, a, b, n)

# Affichage de la courbe
plt.plot(t, u2, label = (f'signal de sortie pour u0={u0} V e(t) = 0' ) )
plt.plot(t, u3, label = (f'signal de sortie pour u0={u0} V et e(t) ={E} cos(wet) ' ) )
plt.plot(t, E*g(t), label =(f"signal d'entrée e(t) ={E} cos(wet)"))
plt.title("Ordre 1 méthode d'Euler")
plt.xlabel('t (en s)')
plt.ylabel('u (en V)')   
plt.legend(loc='upper right')                                         
plt.grid()
plt.show()
